<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../gUtil/DbManager.php";

    session_start();
    //controllo di sicurezza, verifica che l'utente sta inviando i campi dalla pagina index.php
    if(!isset($_POST["tokenSicurezza"]) || !isset($_SESSION["tokenSicurezza"])) {
        header("Location: index.php?status=444");
    }
    else if ($_POST["tokenSicurezza"]!= $_SESSION["tokenSicurezza"]) {
        unset($_SESSION["tokenSicurezza"]);
        header("Location: index.php?status=444");
    }
    else {
        unset($_SESSION["tokenSicurezza"]);

        //i dati del database sono definiti nel file costanti.php
        $geecomDb = new DbManager($costantiDatabase);

        //dati admin
        $email    = filter_input(INPUT_POST,"email",FILTER_SANITIZE_STRING);
        $password = hash("sha512",$_POST['password']);

        $queryLogin = "SELECT * FROM geec_utenti WHERE email='$email' AND password='$password' AND (ruolo LIKE 'super admin' OR ruolo LIKE 'amministratore')";
        $result = $geecomDb->eseguiQueryLettura($queryLogin);
        if($result->num_rows>0) {
            $admin = $result->fetch_array(MYSQLI_ASSOC);
            if($admin["stato"]=="non attivato") {
                header("Location: index.php?status=401");                    
            }
            else {                
                $_SESSION["geecomAdmin_id"]    = $admin["id"];
                $_SESSION["geecomAdmin_email"] = $admin["email"];
                $_SESSION["geecomAdmin_ruolo"] = $admin["ruolo"];
                $nomeAdmin = explode(" ",$admin["nome"]); 
                $_SESSION["geecomAdmin_nome"] = $nomeAdmin[0]; //prendo solo il primo nome, che verrà mostrato in alto a destra 
                $_SESSION["geecomAdmin_nomeCognome"] = $admin["nome"]." ".$admin["cognome"]; //usato quando si inseriscono contenuti (es articoli, gallerie) nel db

                // un amministratore può entrare anche nell'area riservata degli utenti, quindi
                // mettiamo le variabili di sessione necessarie per questo
                $_SESSION["geecomUser_id"]          = $admin["id"];
                $_SESSION["geecomUser_email"]       = $admin["email"];
                $_SESSION["geecomUser_nomeCognome"] = $admin["nome"]." ".$admin["cognome"];
                $_SESSION["geecomUser_nome"]        = $admin["nome"];
                $_SESSION["geecomUser_tipoLogin"]   = "email";
                $_SESSION["geecomUser_foto"]        = ($admin["foto"]!="") ? $admin["foto"] : "immagini/altro/segnaPostoUtente.png";

                $gruppiUtente = array();
                $queryGruppo  = "SELECT idGruppo FROM geec_gruppiUtenti WHERE idUtente={$_SESSION["geecomUser_id"]}";
                $risnumMessaggi = $geecomDb->eseguiQueryLettura($queryGruppo);
                while($gruppo = $risnumMessaggi->fetch_assoc()) {
                    $gruppiUtente[count($gruppiUtente)] = $gruppo["idGruppo"];
                }

                $_SESSION["geecomUser_gruppiUtente"] = $gruppiUtente;
                header("Location: home.php");
            }
        }
        else {
            header("Location: index.php?status=400");
        }
    }